<?php

declare(strict_types=1);

/*
 * Node Bundle for Contao Open Source CMS.
 *
 * @copyright  Copyright (c) 2019, terminal42 gmbh
 * @author     terminal42 <https://terminal42.ch>
 * @license    MIT
 */

namespace Terminal42\NodeBundle\Model;

use Contao\ContentModel;
use Contao\Model;
use Contao\Model\Collection;

class NodeModel extends Model
{
    /**
     * Types.
     */
    const TYPE_CONTENT = 'content';
    const TYPE_FOLDER = 'folder';

    /**
     * Table name.
     *
     * @var string
     */
    protected static $strTable = 'tl_node';

    /**
     * Get the content elements.
     */
    public function getContentElements(): ?Collection
    {
        return ContentModel::findPublishedByPidAndTable($this->id, static::getTable());
    }
}
